#ifdef GL_ES
precision mediump float;
#endif

// output from the vertex shader (fragment color and texture coordinates)
varying vec4 v_fragmentColor;
varying vec2 v_texCoord;


const vec3 GRAYSCALE_PAL	= vec3(0.2990, 0.5870, 0.1140);
const vec3 GRAYSCALE_HDTV	= vec3(0.2126, 0.7152, 0.0722);


// main shader function
void main() {
	vec4 texel = texture2D(CC_Texture0, v_texCoord);
	vec3 texel_color = (texel.a == 0.0 ? vec3(0.0) : (texel.rgb / texel.a));
	float texel_gray = dot(texel_color, GRAYSCALE_HDTV);

	vec3 color = mix(
				texel_color,
				v_fragmentColor.rgb * texel_gray,
				v_fragmentColor.a
	);

	gl_FragColor = vec4(color, 1.0) * texel.a;
}
